package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  TagValueType,
  TagKeysType
}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Optional[Map[TagKeysType, TagValueType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKeysType.unwrap(key): java.lang.String) -> (TagValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse =
      zio.aws.cognitoidentityprovider.model
        .ListTagsForResourceResponse(tags.map(value => value))
    def tags: Optional[Map[TagKeysType, TagValueType]]
    def getTags: ZIO[Any, AwsError, Map[TagKeysType, TagValueType]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Optional[Map[TagKeysType, TagValueType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentityprovider.model.primitives.TagKeysType(
                key
              ) -> zio.aws.cognitoidentityprovider.model.primitives
                .TagValueType(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse
  ): zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
