package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AdminGetDeviceResponse(
    device: zio.aws.cognitoidentityprovider.model.DeviceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse = {
    import AdminGetDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse
      .builder()
      .device(device.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse
      .wrap(buildAwsValue())
}
object AdminGetDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse =
      zio.aws.cognitoidentityprovider.model
        .AdminGetDeviceResponse(device.asEditable)
    def device: zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly
    def getDevice: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly
    ] = ZIO.succeed(device)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse
  ) extends zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse.ReadOnly {
    override val device
        : zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.DeviceType.wrap(impl.device())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse
  ): zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse.ReadOnly =
    new Wrapper(impl)
}
