package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  ClientIdType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class GetUiCustomizationRequest(
    userPoolId: UserPoolIdType,
    clientId: Optional[ClientIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest = {
    import GetUiCustomizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        clientId.map(value => ClientIdType.unwrap(value): java.lang.String)
      )(_.clientId)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetUiCustomizationRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetUiCustomizationRequest
      .wrap(buildAwsValue())
}
object GetUiCustomizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.GetUiCustomizationRequest =
      zio.aws.cognitoidentityprovider.model
        .GetUiCustomizationRequest(userPoolId, clientId.map(value => value))
    def userPoolId: UserPoolIdType
    def clientId: Optional[ClientIdType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getClientId: ZIO[Any, AwsError, ClientIdType] =
      AwsError.unwrapOptionField("clientId", clientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest
  ) extends zio.aws.cognitoidentityprovider.model.GetUiCustomizationRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val clientId: Optional[ClientIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientIdType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest
  ): zio.aws.cognitoidentityprovider.model.GetUiCustomizationRequest.ReadOnly =
    new Wrapper(impl)
}
