package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  TokenModelType,
  PasswordType
}
import scala.jdk.CollectionConverters._
final case class ChangePasswordRequest(
    previousPassword: PasswordType,
    proposedPassword: PasswordType,
    accessToken: TokenModelType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest = {
    import ChangePasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest
      .builder()
      .previousPassword(PasswordType.unwrap(previousPassword): java.lang.String)
      .proposedPassword(PasswordType.unwrap(proposedPassword): java.lang.String)
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ChangePasswordRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ChangePasswordRequest
      .wrap(buildAwsValue())
}
object ChangePasswordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ChangePasswordRequest =
      zio.aws.cognitoidentityprovider.model
        .ChangePasswordRequest(previousPassword, proposedPassword, accessToken)
    def previousPassword: PasswordType
    def proposedPassword: PasswordType
    def accessToken: TokenModelType
    def getPreviousPassword: ZIO[Any, Nothing, PasswordType] =
      ZIO.succeed(previousPassword)
    def getProposedPassword: ZIO[Any, Nothing, PasswordType] =
      ZIO.succeed(proposedPassword)
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest
  ) extends zio.aws.cognitoidentityprovider.model.ChangePasswordRequest.ReadOnly {
    override val previousPassword: PasswordType =
      zio.aws.cognitoidentityprovider.model.primitives
        .PasswordType(impl.previousPassword())
    override val proposedPassword: PasswordType =
      zio.aws.cognitoidentityprovider.model.primitives
        .PasswordType(impl.proposedPassword())
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest
  ): zio.aws.cognitoidentityprovider.model.ChangePasswordRequest.ReadOnly =
    new Wrapper(impl)
}
