package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType
import scala.jdk.CollectionConverters._
final case class DescribeUserPoolRequest(userPoolId: UserPoolIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest = {
    import DescribeUserPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeUserPoolRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolRequest
      .wrap(buildAwsValue())
}
object DescribeUserPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeUserPoolRequest =
      zio.aws.cognitoidentityprovider.model.DescribeUserPoolRequest(userPoolId)
    def userPoolId: UserPoolIdType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest
  ) extends zio.aws.cognitoidentityprovider.model.DescribeUserPoolRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest
  ): zio.aws.cognitoidentityprovider.model.DescribeUserPoolRequest.ReadOnly =
    new Wrapper(impl)
}
