package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class GetCsvHeaderResponse(
    userPoolId: Optional[UserPoolIdType] = Optional.Absent,
    csvHeader: Optional[Iterable[StringType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse = {
    import GetCsvHeaderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse
      .builder()
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        csvHeader.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.csvHeader)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse
      .wrap(buildAwsValue())
}
object GetCsvHeaderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse =
      zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse(
        userPoolId.map(value => value),
        csvHeader.map(value => value)
      )
    def userPoolId: Optional[UserPoolIdType]
    def csvHeader: Optional[List[StringType]]
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getCsvHeader: ZIO[Any, AwsError, List[StringType]] =
      AwsError.unwrapOptionField("csvHeader", csvHeader)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse
  ) extends zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse.ReadOnly {
    override val userPoolId: Optional[UserPoolIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val csvHeader: Optional[List[StringType]] = zio.aws.core.internal
      .optionalFromNullable(impl.csvHeader())
      .map(value =>
        value.asScala.map { item =>
          item: StringType
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse
  ): zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse.ReadOnly =
    new Wrapper(impl)
}
