package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  ResourceServerScopeDescriptionType,
  ResourceServerScopeNameType
}
import scala.jdk.CollectionConverters._
final case class ResourceServerScopeType(
    scopeName: ResourceServerScopeNameType,
    scopeDescription: ResourceServerScopeDescriptionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType = {
    import ResourceServerScopeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType
      .builder()
      .scopeName(
        ResourceServerScopeNameType.unwrap(scopeName): java.lang.String
      )
      .scopeDescription(
        ResourceServerScopeDescriptionType.unwrap(
          scopeDescription
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ResourceServerScopeType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ResourceServerScopeType
      .wrap(buildAwsValue())
}
object ResourceServerScopeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ResourceServerScopeType =
      zio.aws.cognitoidentityprovider.model
        .ResourceServerScopeType(scopeName, scopeDescription)
    def scopeName: ResourceServerScopeNameType
    def scopeDescription: ResourceServerScopeDescriptionType
    def getScopeName: ZIO[Any, Nothing, ResourceServerScopeNameType] =
      ZIO.succeed(scopeName)
    def getScopeDescription
        : ZIO[Any, Nothing, ResourceServerScopeDescriptionType] =
      ZIO.succeed(scopeDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType
  ) extends zio.aws.cognitoidentityprovider.model.ResourceServerScopeType.ReadOnly {
    override val scopeName: ResourceServerScopeNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ResourceServerScopeNameType(impl.scopeName())
    override val scopeDescription: ResourceServerScopeDescriptionType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ResourceServerScopeDescriptionType(impl.scopeDescription())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType
  ): zio.aws.cognitoidentityprovider.model.ResourceServerScopeType.ReadOnly =
    new Wrapper(impl)
}
