package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  EmailNotificationBodyType,
  EmailNotificationSubjectType
}
import scala.jdk.CollectionConverters._
final case class NotifyEmailType(
    subject: EmailNotificationSubjectType,
    htmlBody: Optional[EmailNotificationBodyType] = Optional.Absent,
    textBody: Optional[EmailNotificationBodyType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyEmailType = {
    import NotifyEmailType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyEmailType
      .builder()
      .subject(EmailNotificationSubjectType.unwrap(subject): java.lang.String)
      .optionallyWith(
        htmlBody.map(value =>
          EmailNotificationBodyType.unwrap(value): java.lang.String
        )
      )(_.htmlBody)
      .optionallyWith(
        textBody.map(value =>
          EmailNotificationBodyType.unwrap(value): java.lang.String
        )
      )(_.textBody)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.NotifyEmailType.wrap(buildAwsValue())
}
object NotifyEmailType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyEmailType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.NotifyEmailType =
      zio.aws.cognitoidentityprovider.model.NotifyEmailType(
        subject,
        htmlBody.map(value => value),
        textBody.map(value => value)
      )
    def subject: EmailNotificationSubjectType
    def htmlBody: Optional[EmailNotificationBodyType]
    def textBody: Optional[EmailNotificationBodyType]
    def getSubject: ZIO[Any, Nothing, EmailNotificationSubjectType] =
      ZIO.succeed(subject)
    def getHtmlBody: ZIO[Any, AwsError, EmailNotificationBodyType] =
      AwsError.unwrapOptionField("htmlBody", htmlBody)
    def getTextBody: ZIO[Any, AwsError, EmailNotificationBodyType] =
      AwsError.unwrapOptionField("textBody", textBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyEmailType
  ) extends zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly {
    override val subject: EmailNotificationSubjectType =
      zio.aws.cognitoidentityprovider.model.primitives
        .EmailNotificationSubjectType(impl.subject())
    override val htmlBody: Optional[EmailNotificationBodyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.htmlBody())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .EmailNotificationBodyType(value)
        )
    override val textBody: Optional[EmailNotificationBodyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textBody())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .EmailNotificationBodyType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyEmailType
  ): zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly =
    new Wrapper(impl)
}
