package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType
import scala.jdk.CollectionConverters._
final case class GetUserPoolMfaConfigRequest(userPoolId: UserPoolIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest = {
    import GetUserPoolMfaConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest
      .wrap(buildAwsValue())
}
object GetUserPoolMfaConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest =
      zio.aws.cognitoidentityprovider.model
        .GetUserPoolMfaConfigRequest(userPoolId)
    def userPoolId: UserPoolIdType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest
  ) extends zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest
  ): zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest.ReadOnly =
    new Wrapper(impl)
}
