package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  ResourceServerIdentifierType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class DescribeResourceServerRequest(
    userPoolId: UserPoolIdType,
    identifier: ResourceServerIdentifierType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest = {
    import DescribeResourceServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .identifier(
        ResourceServerIdentifierType.unwrap(identifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeResourceServerRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeResourceServerRequest
      .wrap(buildAwsValue())
}
object DescribeResourceServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeResourceServerRequest =
      zio.aws.cognitoidentityprovider.model
        .DescribeResourceServerRequest(userPoolId, identifier)
    def userPoolId: UserPoolIdType
    def identifier: ResourceServerIdentifierType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getIdentifier: ZIO[Any, Nothing, ResourceServerIdentifierType] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest
  ) extends zio.aws.cognitoidentityprovider.model.DescribeResourceServerRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val identifier: ResourceServerIdentifierType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ResourceServerIdentifierType(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest
  ): zio.aws.cognitoidentityprovider.model.DescribeResourceServerRequest.ReadOnly =
    new Wrapper(impl)
}
