package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  UsernameType,
  SecretHashType,
  ClientIdType
}
import scala.jdk.CollectionConverters._
final case class ResendConfirmationCodeRequest(
    clientId: ClientIdType,
    secretHash: Optional[SecretHashType] = Optional.Absent,
    userContextData: Optional[
      zio.aws.cognitoidentityprovider.model.UserContextDataType
    ] = Optional.Absent,
    username: UsernameType,
    analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType
    ] = Optional.Absent,
    clientMetadata: Optional[Map[StringType, StringType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest = {
    import ResendConfirmationCodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest
      .builder()
      .clientId(ClientIdType.unwrap(clientId): java.lang.String)
      .optionallyWith(
        secretHash.map(value => SecretHashType.unwrap(value): java.lang.String)
      )(_.secretHash)
      .optionallyWith(userContextData.map(value => value.buildAwsValue()))(
        _.userContextData
      )
      .username(UsernameType.unwrap(username): java.lang.String)
      .optionallyWith(analyticsMetadata.map(value => value.buildAwsValue()))(
        _.analyticsMetadata
      )
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeRequest
      .wrap(buildAwsValue())
}
object ResendConfirmationCodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeRequest =
      zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeRequest(
        clientId,
        secretHash.map(value => value),
        userContextData.map(value => value.asEditable),
        username,
        analyticsMetadata.map(value => value.asEditable),
        clientMetadata.map(value => value)
      )
    def clientId: ClientIdType
    def secretHash: Optional[SecretHashType]
    def userContextData: Optional[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ]
    def username: UsernameType
    def analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ]
    def clientMetadata: Optional[Map[StringType, StringType]]
    def getClientId: ZIO[Any, Nothing, ClientIdType] = ZIO.succeed(clientId)
    def getSecretHash: ZIO[Any, AwsError, SecretHashType] =
      AwsError.unwrapOptionField("secretHash", secretHash)
    def getUserContextData: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = AwsError.unwrapOptionField("userContextData", userContextData)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getAnalyticsMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = AwsError.unwrapOptionField("analyticsMetadata", analyticsMetadata)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest
  ) extends zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeRequest.ReadOnly {
    override val clientId: ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ClientIdType(impl.clientId())
    override val secretHash: Optional[SecretHashType] = zio.aws.core.internal
      .optionalFromNullable(impl.secretHash())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SecretHashType(value)
      )
    override val userContextData: Optional[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userContextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserContextDataType.wrap(value)
      )
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.analyticsMetadata())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.wrap(value)
      )
    override val clientMetadata: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest
  ): zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeRequest.ReadOnly =
    new Wrapper(impl)
}
