package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  ClientIdType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class DescribeRiskConfigurationRequest(
    userPoolId: UserPoolIdType,
    clientId: Optional[ClientIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest = {
    import DescribeRiskConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        clientId.map(value => ClientIdType.unwrap(value): java.lang.String)
      )(_.clientId)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeRiskConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationRequest =
      zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationRequest(
        userPoolId,
        clientId.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def clientId: Optional[ClientIdType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getClientId: ZIO[Any, AwsError, ClientIdType] =
      AwsError.unwrapOptionField("clientId", clientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest
  ) extends zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val clientId: Optional[ClientIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientIdType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest
  ): zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
