package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  SoftwareTokenMFAUserCodeType,
  SessionType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class VerifySoftwareTokenRequest(
    accessToken: Optional[TokenModelType] = Optional.Absent,
    session: Optional[SessionType] = Optional.Absent,
    userCode: SoftwareTokenMFAUserCodeType,
    friendlyDeviceName: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest = {
    import VerifySoftwareTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest
      .builder()
      .optionallyWith(
        accessToken.map(value => TokenModelType.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .userCode(SoftwareTokenMFAUserCodeType.unwrap(userCode): java.lang.String)
      .optionallyWith(friendlyDeviceName.map(value => value: java.lang.String))(
        _.friendlyDeviceName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest
      .wrap(buildAwsValue())
}
object VerifySoftwareTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest =
      zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest(
        accessToken.map(value => value),
        session.map(value => value),
        userCode,
        friendlyDeviceName.map(value => value)
      )
    def accessToken: Optional[TokenModelType]
    def session: Optional[SessionType]
    def userCode: SoftwareTokenMFAUserCodeType
    def friendlyDeviceName: Optional[StringType]
    def getAccessToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
    def getUserCode: ZIO[Any, Nothing, SoftwareTokenMFAUserCodeType] =
      ZIO.succeed(userCode)
    def getFriendlyDeviceName: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("friendlyDeviceName", friendlyDeviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest
  ) extends zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest.ReadOnly {
    override val accessToken: Optional[TokenModelType] = zio.aws.core.internal
      .optionalFromNullable(impl.accessToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
    override val session: Optional[SessionType] = zio.aws.core.internal
      .optionalFromNullable(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
    override val userCode: SoftwareTokenMFAUserCodeType =
      zio.aws.cognitoidentityprovider.model.primitives
        .SoftwareTokenMFAUserCodeType(impl.userCode())
    override val friendlyDeviceName: Optional[StringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.friendlyDeviceName())
        .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest
  ): zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest.ReadOnly =
    new Wrapper(impl)
}
