package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetRiskConfigurationResponse(
    riskConfiguration: zio.aws.cognitoidentityprovider.model.RiskConfigurationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse = {
    import SetRiskConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse
      .builder()
      .riskConfiguration(riskConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse
      .wrap(buildAwsValue())
}
object SetRiskConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse =
      zio.aws.cognitoidentityprovider.model
        .SetRiskConfigurationResponse(riskConfiguration.asEditable)
    def riskConfiguration
        : zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly
    def getRiskConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly
    ] = ZIO.succeed(riskConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse
  ) extends zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse.ReadOnly {
    override val riskConfiguration
        : zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.RiskConfigurationType
        .wrap(impl.riskConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse
  ): zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
