package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  AttributeNameType,
  UserPoolIdType,
  UserFilterType,
  QueryLimitType,
  SearchPaginationTokenType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUsersRequest(
    userPoolId: UserPoolIdType,
    attributesToGet: Optional[Iterable[AttributeNameType]] = Optional.Absent,
    limit: Optional[QueryLimitType] = Optional.Absent,
    paginationToken: Optional[SearchPaginationTokenType] = Optional.Absent,
    filter: Optional[UserFilterType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest = {
    import ListUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        attributesToGet.map(value =>
          value.map { item =>
            AttributeNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributesToGet)
      .optionallyWith(
        limit.map(value => QueryLimitType.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        paginationToken.map(value =>
          SearchPaginationTokenType.unwrap(value): java.lang.String
        )
      )(_.paginationToken)
      .optionallyWith(
        filter.map(value => UserFilterType.unwrap(value): java.lang.String)
      )(_.filter)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUsersRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUsersRequest.wrap(buildAwsValue())
}
object ListUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ListUsersRequest =
      zio.aws.cognitoidentityprovider.model.ListUsersRequest(
        userPoolId,
        attributesToGet.map(value => value),
        limit.map(value => value),
        paginationToken.map(value => value),
        filter.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def attributesToGet: Optional[List[AttributeNameType]]
    def limit: Optional[QueryLimitType]
    def paginationToken: Optional[SearchPaginationTokenType]
    def filter: Optional[UserFilterType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getAttributesToGet: ZIO[Any, AwsError, List[AttributeNameType]] =
      AwsError.unwrapOptionField("attributesToGet", attributesToGet)
    def getLimit: ZIO[Any, AwsError, QueryLimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getPaginationToken: ZIO[Any, AwsError, SearchPaginationTokenType] =
      AwsError.unwrapOptionField("paginationToken", paginationToken)
    def getFilter: ZIO[Any, AwsError, UserFilterType] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListUsersRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val attributesToGet: Optional[List[AttributeNameType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributesToGet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.primitives
              .AttributeNameType(item)
          }.toList
        )
    override val limit: Optional[QueryLimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.QueryLimitType(value)
      )
    override val paginationToken: Optional[SearchPaginationTokenType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paginationToken())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .SearchPaginationTokenType(value)
        )
    override val filter: Optional[UserFilterType] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserFilterType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest
  ): zio.aws.cognitoidentityprovider.model.ListUsersRequest.ReadOnly =
    new Wrapper(impl)
}
