package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKeyType
import scala.jdk.CollectionConverters._
final case class ListIdentityProvidersResponse(
    providers: Iterable[
      zio.aws.cognitoidentityprovider.model.ProviderDescription
    ],
    nextToken: Optional[PaginationKeyType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse = {
    import ListIdentityProvidersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse
      .builder()
      .providers(providers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value =>
          PaginationKeyType.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse
      .wrap(buildAwsValue())
}
object ListIdentityProvidersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse =
      zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse(
        providers.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def providers: List[
      zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly
    ]
    def nextToken: Optional[PaginationKeyType]
    def getProviders: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly
    ]] = ZIO.succeed(providers)
    def getNextToken: ZIO[Any, AwsError, PaginationKeyType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse.ReadOnly {
    override val providers: List[
      zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly
    ] = impl
      .providers()
      .asScala
      .map { item =>
        zio.aws.cognitoidentityprovider.model.ProviderDescription.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .PaginationKeyType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse
  ): zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse.ReadOnly =
    new Wrapper(impl)
}
