package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateUserPoolClientResponse(
    userPoolClient: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolClientType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse = {
    import UpdateUserPoolClientResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse
      .builder()
      .optionallyWith(userPoolClient.map(value => value.buildAwsValue()))(
        _.userPoolClient
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse
      .wrap(buildAwsValue())
}
object UpdateUserPoolClientResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse =
      zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse(
        userPoolClient.map(value => value.asEditable)
      )
    def userPoolClient: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly
    ]
    def getUserPoolClient: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly
    ] = AwsError.unwrapOptionField("userPoolClient", userPoolClient)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse
  ) extends zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse.ReadOnly {
    override val userPoolClient: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolClient())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolClientType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse
  ): zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse.ReadOnly =
    new Wrapper(impl)
}
