package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChallengeResponseType(
    challengeName: Optional[
      zio.aws.cognitoidentityprovider.model.ChallengeName
    ] = Optional.Absent,
    challengeResponse: Optional[
      zio.aws.cognitoidentityprovider.model.ChallengeResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType = {
    import ChallengeResponseType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType
      .builder()
      .optionallyWith(challengeName.map(value => value.unwrap))(_.challengeName)
      .optionallyWith(challengeResponse.map(value => value.unwrap))(
        _.challengeResponse
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ChallengeResponseType
      .wrap(buildAwsValue())
}
object ChallengeResponseType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ChallengeResponseType =
      zio.aws.cognitoidentityprovider.model.ChallengeResponseType(
        challengeName.map(value => value),
        challengeResponse.map(value => value)
      )
    def challengeName
        : Optional[zio.aws.cognitoidentityprovider.model.ChallengeName]
    def challengeResponse
        : Optional[zio.aws.cognitoidentityprovider.model.ChallengeResponse]
    def getChallengeName: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ChallengeName
    ] = AwsError.unwrapOptionField("challengeName", challengeName)
    def getChallengeResponse: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ChallengeResponse
    ] = AwsError.unwrapOptionField("challengeResponse", challengeResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType
  ) extends zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly {
    override val challengeName
        : Optional[zio.aws.cognitoidentityprovider.model.ChallengeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.challengeName())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.ChallengeName.wrap(value)
        )
    override val challengeResponse
        : Optional[zio.aws.cognitoidentityprovider.model.ChallengeResponse] =
      zio.aws.core.internal
        .optionalFromNullable(impl.challengeResponse())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.ChallengeResponse.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType
  ): zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly =
    new Wrapper(impl)
}
