package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  PaginationKeyType,
  ListProvidersLimitType,
  UserPoolIdType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListIdentityProvidersRequest(
    userPoolId: UserPoolIdType,
    maxResults: Optional[ListProvidersLimitType] = Optional.Absent,
    nextToken: Optional[PaginationKeyType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest = {
    import ListIdentityProvidersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => ListProvidersLimitType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          PaginationKeyType.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest
      .wrap(buildAwsValue())
}
object ListIdentityProvidersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest =
      zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest(
        userPoolId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def maxResults: Optional[ListProvidersLimitType]
    def nextToken: Optional[PaginationKeyType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getMaxResults: ZIO[Any, AwsError, ListProvidersLimitType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationKeyType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val maxResults: Optional[ListProvidersLimitType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .ListProvidersLimitType(value)
        )
    override val nextToken: Optional[PaginationKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .PaginationKeyType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest
  ): zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest.ReadOnly =
    new Wrapper(impl)
}
