package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class EventContextDataType(
    ipAddress: Optional[StringType] = Optional.Absent,
    deviceName: Optional[StringType] = Optional.Absent,
    timezone: Optional[StringType] = Optional.Absent,
    city: Optional[StringType] = Optional.Absent,
    country: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType = {
    import EventContextDataType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType
      .builder()
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(city.map(value => value: java.lang.String))(_.city)
      .optionallyWith(country.map(value => value: java.lang.String))(_.country)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.EventContextDataType
      .wrap(buildAwsValue())
}
object EventContextDataType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.EventContextDataType =
      zio.aws.cognitoidentityprovider.model.EventContextDataType(
        ipAddress.map(value => value),
        deviceName.map(value => value),
        timezone.map(value => value),
        city.map(value => value),
        country.map(value => value)
      )
    def ipAddress: Optional[StringType]
    def deviceName: Optional[StringType]
    def timezone: Optional[StringType]
    def city: Optional[StringType]
    def country: Optional[StringType]
    def getIpAddress: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getDeviceName: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getTimezone: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getCity: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("city", city)
    def getCountry: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("country", country)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType
  ) extends zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly {
    override val ipAddress: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => value: StringType)
    override val deviceName: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => value: StringType)
    override val timezone: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => value: StringType)
    override val city: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.city())
      .map(value => value: StringType)
    override val country: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType
  ): zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly =
    new Wrapper(impl)
}
