package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.PriorityType
import scala.jdk.CollectionConverters._
final case class RecoveryOptionType(
    priority: PriorityType,
    name: zio.aws.cognitoidentityprovider.model.RecoveryOptionNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionType = {
    import RecoveryOptionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionType
      .builder()
      .priority(PriorityType.unwrap(priority): Integer)
      .name(name.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.RecoveryOptionType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.RecoveryOptionType
      .wrap(buildAwsValue())
}
object RecoveryOptionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.RecoveryOptionType =
      zio.aws.cognitoidentityprovider.model.RecoveryOptionType(priority, name)
    def priority: PriorityType
    def name: zio.aws.cognitoidentityprovider.model.RecoveryOptionNameType
    def getPriority: ZIO[Any, Nothing, PriorityType] = ZIO.succeed(priority)
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.RecoveryOptionNameType
    ] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionType
  ) extends zio.aws.cognitoidentityprovider.model.RecoveryOptionType.ReadOnly {
    override val priority: PriorityType =
      zio.aws.cognitoidentityprovider.model.primitives
        .PriorityType(impl.priority())
    override val name
        : zio.aws.cognitoidentityprovider.model.RecoveryOptionNameType =
      zio.aws.cognitoidentityprovider.model.RecoveryOptionNameType
        .wrap(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionType
  ): zio.aws.cognitoidentityprovider.model.RecoveryOptionType.ReadOnly =
    new Wrapper(impl)
}
