package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.SessionType
import scala.jdk.CollectionConverters._
final case class VerifySoftwareTokenResponse(
    status: Optional[
      zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponseType
    ] = Optional.Absent,
    session: Optional[SessionType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse = {
    import VerifySoftwareTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse
      .wrap(buildAwsValue())
}
object VerifySoftwareTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse =
      zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse(
        status.map(value => value),
        session.map(value => value)
      )
    def status: Optional[
      zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponseType
    ]
    def session: Optional[SessionType]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponseType
    ] = AwsError.unwrapOptionField("status", status)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse
  ) extends zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse.ReadOnly {
    override val status: Optional[
      zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponseType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponseType
          .wrap(value)
      )
    override val session: Optional[SessionType] = zio.aws.core.internal
      .optionalFromNullable(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse
  ): zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse.ReadOnly =
    new Wrapper(impl)
}
