package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.TokenModelType
import scala.jdk.CollectionConverters._
final case class SetUserSettingsRequest(
    accessToken: TokenModelType,
    mfaOptions: Iterable[zio.aws.cognitoidentityprovider.model.MFAOptionType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest = {
    import SetUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest
      .builder()
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .mfaOptions(mfaOptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SetUserSettingsRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SetUserSettingsRequest
      .wrap(buildAwsValue())
}
object SetUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SetUserSettingsRequest =
      zio.aws.cognitoidentityprovider.model.SetUserSettingsRequest(
        accessToken,
        mfaOptions.map { item =>
          item.asEditable
        }
      )
    def accessToken: TokenModelType
    def mfaOptions
        : List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
    def getMfaOptions: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly
    ]] = ZIO.succeed(mfaOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest
  ) extends zio.aws.cognitoidentityprovider.model.SetUserSettingsRequest.ReadOnly {
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
    override val mfaOptions
        : List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly] =
      impl
        .mfaOptions()
        .asScala
        .map { item =>
          zio.aws.cognitoidentityprovider.model.MFAOptionType.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest
  ): zio.aws.cognitoidentityprovider.model.SetUserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
