package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.ArnType
import scala.jdk.CollectionConverters._
final case class CustomDomainConfigType(certificateArn: ArnType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CustomDomainConfigType = {
    import CustomDomainConfigType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CustomDomainConfigType
      .builder()
      .certificateArn(ArnType.unwrap(certificateArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CustomDomainConfigType
      .wrap(buildAwsValue())
}
object CustomDomainConfigType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CustomDomainConfigType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CustomDomainConfigType =
      zio.aws.cognitoidentityprovider.model
        .CustomDomainConfigType(certificateArn)
    def certificateArn: ArnType
    def getCertificateArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CustomDomainConfigType
  ) extends zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly {
    override val certificateArn: ArnType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ArnType(impl.certificateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CustomDomainConfigType
  ): zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly =
    new Wrapper(impl)
}
