package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait RecoveryOptionNameType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType
}
object RecoveryOptionNameType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType
  ): zio.aws.cognitoidentityprovider.model.RecoveryOptionNameType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType.VERIFIED_EMAIL =>
        val r = verified_email
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType.VERIFIED_PHONE_NUMBER =>
        val r = verified_phone_number
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType.ADMIN_ONLY =>
        val r = admin_only
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.RecoveryOptionNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType.UNKNOWN_TO_SDK_VERSION
  }
  case object verified_email
      extends zio.aws.cognitoidentityprovider.model.RecoveryOptionNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType.VERIFIED_EMAIL
  }
  case object verified_phone_number
      extends zio.aws.cognitoidentityprovider.model.RecoveryOptionNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType.VERIFIED_PHONE_NUMBER
  }
  case object admin_only
      extends zio.aws.cognitoidentityprovider.model.RecoveryOptionNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionNameType.ADMIN_ONLY
  }
}
