package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  BooleanType,
  IdTokenValidityType,
  ScopeType,
  AccessTokenValidityType,
  DateType,
  RedirectUrlType,
  UserPoolIdType,
  WrappedBooleanType,
  ClientIdType,
  ClientSecretType,
  ClientPermissionType,
  ClientNameType,
  RefreshTokenValidityType,
  ProviderNameType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UserPoolClientType(
    userPoolId: Optional[UserPoolIdType] = Optional.Absent,
    clientName: Optional[ClientNameType] = Optional.Absent,
    clientId: Optional[ClientIdType] = Optional.Absent,
    clientSecret: Optional[ClientSecretType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    refreshTokenValidity: Optional[RefreshTokenValidityType] = Optional.Absent,
    accessTokenValidity: Optional[AccessTokenValidityType] = Optional.Absent,
    idTokenValidity: Optional[IdTokenValidityType] = Optional.Absent,
    tokenValidityUnits: Optional[
      zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType
    ] = Optional.Absent,
    readAttributes: Optional[Iterable[ClientPermissionType]] = Optional.Absent,
    writeAttributes: Optional[Iterable[ClientPermissionType]] = Optional.Absent,
    explicitAuthFlows: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.ExplicitAuthFlowsType]
    ] = Optional.Absent,
    supportedIdentityProviders: Optional[Iterable[ProviderNameType]] =
      Optional.Absent,
    callbackURLs: Optional[Iterable[RedirectUrlType]] = Optional.Absent,
    logoutURLs: Optional[Iterable[RedirectUrlType]] = Optional.Absent,
    defaultRedirectURI: Optional[RedirectUrlType] = Optional.Absent,
    allowedOAuthFlows: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.OAuthFlowType]
    ] = Optional.Absent,
    allowedOAuthScopes: Optional[Iterable[ScopeType]] = Optional.Absent,
    allowedOAuthFlowsUserPoolClient: Optional[BooleanType] = Optional.Absent,
    analyticsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType
    ] = Optional.Absent,
    preventUserExistenceErrors: Optional[
      zio.aws.cognitoidentityprovider.model.PreventUserExistenceErrorTypes
    ] = Optional.Absent,
    enableTokenRevocation: Optional[WrappedBooleanType] = Optional.Absent,
    enablePropagateAdditionalUserContextData: Optional[WrappedBooleanType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientType = {
    import UserPoolClientType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientType
      .builder()
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        clientName.map(value => ClientNameType.unwrap(value): java.lang.String)
      )(_.clientName)
      .optionallyWith(
        clientId.map(value => ClientIdType.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        clientSecret.map(value =>
          ClientSecretType.unwrap(value): java.lang.String
        )
      )(_.clientSecret)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        refreshTokenValidity.map(value =>
          RefreshTokenValidityType.unwrap(value): Integer
        )
      )(_.refreshTokenValidity)
      .optionallyWith(
        accessTokenValidity.map(value =>
          AccessTokenValidityType.unwrap(value): Integer
        )
      )(_.accessTokenValidity)
      .optionallyWith(
        idTokenValidity.map(value => IdTokenValidityType.unwrap(value): Integer)
      )(_.idTokenValidity)
      .optionallyWith(tokenValidityUnits.map(value => value.buildAwsValue()))(
        _.tokenValidityUnits
      )
      .optionallyWith(
        readAttributes.map(value =>
          value.map { item =>
            ClientPermissionType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readAttributes)
      .optionallyWith(
        writeAttributes.map(value =>
          value.map { item =>
            ClientPermissionType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.writeAttributes)
      .optionallyWith(
        explicitAuthFlows.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.explicitAuthFlowsWithStrings)
      .optionallyWith(
        supportedIdentityProviders.map(value =>
          value.map { item =>
            ProviderNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedIdentityProviders)
      .optionallyWith(
        callbackURLs.map(value =>
          value.map { item =>
            RedirectUrlType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.callbackURLs)
      .optionallyWith(
        logoutURLs.map(value =>
          value.map { item =>
            RedirectUrlType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logoutURLs)
      .optionallyWith(
        defaultRedirectURI.map(value =>
          RedirectUrlType.unwrap(value): java.lang.String
        )
      )(_.defaultRedirectURI)
      .optionallyWith(
        allowedOAuthFlows.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.allowedOAuthFlowsWithStrings)
      .optionallyWith(
        allowedOAuthScopes.map(value =>
          value.map { item =>
            ScopeType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedOAuthScopes)
      .optionallyWith(
        allowedOAuthFlowsUserPoolClient.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.allowedOAuthFlowsUserPoolClient)
      .optionallyWith(
        analyticsConfiguration.map(value => value.buildAwsValue())
      )(_.analyticsConfiguration)
      .optionallyWith(preventUserExistenceErrors.map(value => value.unwrap))(
        _.preventUserExistenceErrors
      )
      .optionallyWith(
        enableTokenRevocation.map(value =>
          WrappedBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.enableTokenRevocation)
      .optionallyWith(
        enablePropagateAdditionalUserContextData.map(value =>
          WrappedBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.enablePropagateAdditionalUserContextData)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserPoolClientType
      .wrap(buildAwsValue())
}
object UserPoolClientType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UserPoolClientType =
      zio.aws.cognitoidentityprovider.model.UserPoolClientType(
        userPoolId.map(value => value),
        clientName.map(value => value),
        clientId.map(value => value),
        clientSecret.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value),
        refreshTokenValidity.map(value => value),
        accessTokenValidity.map(value => value),
        idTokenValidity.map(value => value),
        tokenValidityUnits.map(value => value.asEditable),
        readAttributes.map(value => value),
        writeAttributes.map(value => value),
        explicitAuthFlows.map(value => value),
        supportedIdentityProviders.map(value => value),
        callbackURLs.map(value => value),
        logoutURLs.map(value => value),
        defaultRedirectURI.map(value => value),
        allowedOAuthFlows.map(value => value),
        allowedOAuthScopes.map(value => value),
        allowedOAuthFlowsUserPoolClient.map(value => value),
        analyticsConfiguration.map(value => value.asEditable),
        preventUserExistenceErrors.map(value => value),
        enableTokenRevocation.map(value => value),
        enablePropagateAdditionalUserContextData.map(value => value)
      )
    def userPoolId: Optional[UserPoolIdType]
    def clientName: Optional[ClientNameType]
    def clientId: Optional[ClientIdType]
    def clientSecret: Optional[ClientSecretType]
    def lastModifiedDate: Optional[DateType]
    def creationDate: Optional[DateType]
    def refreshTokenValidity: Optional[RefreshTokenValidityType]
    def accessTokenValidity: Optional[AccessTokenValidityType]
    def idTokenValidity: Optional[IdTokenValidityType]
    def tokenValidityUnits: Optional[
      zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType.ReadOnly
    ]
    def readAttributes: Optional[List[ClientPermissionType]]
    def writeAttributes: Optional[List[ClientPermissionType]]
    def explicitAuthFlows: Optional[
      List[zio.aws.cognitoidentityprovider.model.ExplicitAuthFlowsType]
    ]
    def supportedIdentityProviders: Optional[List[ProviderNameType]]
    def callbackURLs: Optional[List[RedirectUrlType]]
    def logoutURLs: Optional[List[RedirectUrlType]]
    def defaultRedirectURI: Optional[RedirectUrlType]
    def allowedOAuthFlows
        : Optional[List[zio.aws.cognitoidentityprovider.model.OAuthFlowType]]
    def allowedOAuthScopes: Optional[List[ScopeType]]
    def allowedOAuthFlowsUserPoolClient: Optional[BooleanType]
    def analyticsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType.ReadOnly
    ]
    def preventUserExistenceErrors: Optional[
      zio.aws.cognitoidentityprovider.model.PreventUserExistenceErrorTypes
    ]
    def enableTokenRevocation: Optional[WrappedBooleanType]
    def enablePropagateAdditionalUserContextData: Optional[WrappedBooleanType]
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getClientName: ZIO[Any, AwsError, ClientNameType] =
      AwsError.unwrapOptionField("clientName", clientName)
    def getClientId: ZIO[Any, AwsError, ClientIdType] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getClientSecret: ZIO[Any, AwsError, ClientSecretType] =
      AwsError.unwrapOptionField("clientSecret", clientSecret)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getRefreshTokenValidity: ZIO[Any, AwsError, RefreshTokenValidityType] =
      AwsError.unwrapOptionField("refreshTokenValidity", refreshTokenValidity)
    def getAccessTokenValidity: ZIO[Any, AwsError, AccessTokenValidityType] =
      AwsError.unwrapOptionField("accessTokenValidity", accessTokenValidity)
    def getIdTokenValidity: ZIO[Any, AwsError, IdTokenValidityType] =
      AwsError.unwrapOptionField("idTokenValidity", idTokenValidity)
    def getTokenValidityUnits: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType.ReadOnly
    ] = AwsError.unwrapOptionField("tokenValidityUnits", tokenValidityUnits)
    def getReadAttributes: ZIO[Any, AwsError, List[ClientPermissionType]] =
      AwsError.unwrapOptionField("readAttributes", readAttributes)
    def getWriteAttributes: ZIO[Any, AwsError, List[ClientPermissionType]] =
      AwsError.unwrapOptionField("writeAttributes", writeAttributes)
    def getExplicitAuthFlows: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.ExplicitAuthFlowsType
    ]] = AwsError.unwrapOptionField("explicitAuthFlows", explicitAuthFlows)
    def getSupportedIdentityProviders
        : ZIO[Any, AwsError, List[ProviderNameType]] =
      AwsError.unwrapOptionField(
        "supportedIdentityProviders",
        supportedIdentityProviders
      )
    def getCallbackURLs: ZIO[Any, AwsError, List[RedirectUrlType]] =
      AwsError.unwrapOptionField("callbackURLs", callbackURLs)
    def getLogoutURLs: ZIO[Any, AwsError, List[RedirectUrlType]] =
      AwsError.unwrapOptionField("logoutURLs", logoutURLs)
    def getDefaultRedirectURI: ZIO[Any, AwsError, RedirectUrlType] =
      AwsError.unwrapOptionField("defaultRedirectURI", defaultRedirectURI)
    def getAllowedOAuthFlows: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.OAuthFlowType
    ]] = AwsError.unwrapOptionField("allowedOAuthFlows", allowedOAuthFlows)
    def getAllowedOAuthScopes: ZIO[Any, AwsError, List[ScopeType]] =
      AwsError.unwrapOptionField("allowedOAuthScopes", allowedOAuthScopes)
    def getAllowedOAuthFlowsUserPoolClient: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "allowedOAuthFlowsUserPoolClient",
        allowedOAuthFlowsUserPoolClient
      )
    def getAnalyticsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "analyticsConfiguration",
      analyticsConfiguration
    )
    def getPreventUserExistenceErrors: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.PreventUserExistenceErrorTypes
    ] = AwsError.unwrapOptionField(
      "preventUserExistenceErrors",
      preventUserExistenceErrors
    )
    def getEnableTokenRevocation: ZIO[Any, AwsError, WrappedBooleanType] =
      AwsError.unwrapOptionField("enableTokenRevocation", enableTokenRevocation)
    def getEnablePropagateAdditionalUserContextData
        : ZIO[Any, AwsError, WrappedBooleanType] = AwsError.unwrapOptionField(
      "enablePropagateAdditionalUserContextData",
      enablePropagateAdditionalUserContextData
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientType
  ) extends zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly {
    override val userPoolId: Optional[UserPoolIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val clientName: Optional[ClientNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.clientName())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientNameType(value)
      )
    override val clientId: Optional[ClientIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientIdType(value)
      )
    override val clientSecret: Optional[ClientSecretType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientSecret())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .ClientSecretType(value)
        )
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val refreshTokenValidity: Optional[RefreshTokenValidityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.refreshTokenValidity())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .RefreshTokenValidityType(value)
        )
    override val accessTokenValidity: Optional[AccessTokenValidityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessTokenValidity())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .AccessTokenValidityType(value)
        )
    override val idTokenValidity: Optional[IdTokenValidityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idTokenValidity())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .IdTokenValidityType(value)
        )
    override val tokenValidityUnits: Optional[
      zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenValidityUnits())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType.wrap(value)
      )
    override val readAttributes: Optional[List[ClientPermissionType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.primitives
              .ClientPermissionType(item)
          }.toList
        )
    override val writeAttributes: Optional[List[ClientPermissionType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.primitives
              .ClientPermissionType(item)
          }.toList
        )
    override val explicitAuthFlows: Optional[
      List[zio.aws.cognitoidentityprovider.model.ExplicitAuthFlowsType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.explicitAuthFlows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.ExplicitAuthFlowsType.wrap(item)
        }.toList
      )
    override val supportedIdentityProviders: Optional[List[ProviderNameType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedIdentityProviders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.primitives
              .ProviderNameType(item)
          }.toList
        )
    override val callbackURLs: Optional[List[RedirectUrlType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callbackURLs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.primitives
              .RedirectUrlType(item)
          }.toList
        )
    override val logoutURLs: Optional[List[RedirectUrlType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logoutURLs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.primitives
              .RedirectUrlType(item)
          }.toList
        )
    override val defaultRedirectURI: Optional[RedirectUrlType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultRedirectURI())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .RedirectUrlType(value)
        )
    override val allowedOAuthFlows
        : Optional[List[zio.aws.cognitoidentityprovider.model.OAuthFlowType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedOAuthFlows())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.OAuthFlowType.wrap(item)
          }.toList
        )
    override val allowedOAuthScopes: Optional[List[ScopeType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedOAuthScopes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.primitives.ScopeType(item)
          }.toList
        )
    override val allowedOAuthFlowsUserPoolClient: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedOAuthFlowsUserPoolClient())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
        )
    override val analyticsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.analyticsConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType
          .wrap(value)
      )
    override val preventUserExistenceErrors: Optional[
      zio.aws.cognitoidentityprovider.model.PreventUserExistenceErrorTypes
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.preventUserExistenceErrors())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.PreventUserExistenceErrorTypes
          .wrap(value)
      )
    override val enableTokenRevocation: Optional[WrappedBooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableTokenRevocation())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .WrappedBooleanType(value)
        )
    override val enablePropagateAdditionalUserContextData
        : Optional[WrappedBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.enablePropagateAdditionalUserContextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .WrappedBooleanType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientType
  ): zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly =
    new Wrapper(impl)
}
