package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.AttributeNameType
import scala.jdk.CollectionConverters._
final case class MFAOptionType(
    deliveryMedium: Optional[
      zio.aws.cognitoidentityprovider.model.DeliveryMediumType
    ] = Optional.Absent,
    attributeName: Optional[AttributeNameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType = {
    import MFAOptionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType
      .builder()
      .optionallyWith(deliveryMedium.map(value => value.unwrap))(
        _.deliveryMedium
      )
      .optionallyWith(
        attributeName.map(value =>
          AttributeNameType.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.MFAOptionType.wrap(buildAwsValue())
}
object MFAOptionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.MFAOptionType =
      zio.aws.cognitoidentityprovider.model.MFAOptionType(
        deliveryMedium.map(value => value),
        attributeName.map(value => value)
      )
    def deliveryMedium
        : Optional[zio.aws.cognitoidentityprovider.model.DeliveryMediumType]
    def attributeName: Optional[AttributeNameType]
    def getDeliveryMedium: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeliveryMediumType
    ] = AwsError.unwrapOptionField("deliveryMedium", deliveryMedium)
    def getAttributeName: ZIO[Any, AwsError, AttributeNameType] =
      AwsError.unwrapOptionField("attributeName", attributeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType
  ) extends zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly {
    override val deliveryMedium
        : Optional[zio.aws.cognitoidentityprovider.model.DeliveryMediumType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryMedium())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.DeliveryMediumType.wrap(value)
        )
    override val attributeName: Optional[AttributeNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeName())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .AttributeNameType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType
  ): zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly = new Wrapper(
    impl
  )
}
