package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.ArnType
import scala.jdk.CollectionConverters._
final case class LambdaConfigType(
    preSignUp: Optional[ArnType] = Optional.Absent,
    customMessage: Optional[ArnType] = Optional.Absent,
    postConfirmation: Optional[ArnType] = Optional.Absent,
    preAuthentication: Optional[ArnType] = Optional.Absent,
    postAuthentication: Optional[ArnType] = Optional.Absent,
    defineAuthChallenge: Optional[ArnType] = Optional.Absent,
    createAuthChallenge: Optional[ArnType] = Optional.Absent,
    verifyAuthChallengeResponse: Optional[ArnType] = Optional.Absent,
    preTokenGeneration: Optional[ArnType] = Optional.Absent,
    userMigration: Optional[ArnType] = Optional.Absent,
    customSMSSender: Optional[
      zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType
    ] = Optional.Absent,
    customEmailSender: Optional[
      zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType
    ] = Optional.Absent,
    kmsKeyID: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType = {
    import LambdaConfigType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType
      .builder()
      .optionallyWith(
        preSignUp.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.preSignUp)
      .optionallyWith(
        customMessage.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.customMessage)
      .optionallyWith(
        postConfirmation.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.postConfirmation)
      .optionallyWith(
        preAuthentication.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.preAuthentication)
      .optionallyWith(
        postAuthentication.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.postAuthentication)
      .optionallyWith(
        defineAuthChallenge.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.defineAuthChallenge)
      .optionallyWith(
        createAuthChallenge.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.createAuthChallenge)
      .optionallyWith(
        verifyAuthChallengeResponse.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.verifyAuthChallengeResponse)
      .optionallyWith(
        preTokenGeneration.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.preTokenGeneration)
      .optionallyWith(
        userMigration.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.userMigration)
      .optionallyWith(customSMSSender.map(value => value.buildAwsValue()))(
        _.customSMSSender
      )
      .optionallyWith(customEmailSender.map(value => value.buildAwsValue()))(
        _.customEmailSender
      )
      .optionallyWith(
        kmsKeyID.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.kmsKeyID)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.LambdaConfigType.wrap(buildAwsValue())
}
object LambdaConfigType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.LambdaConfigType =
      zio.aws.cognitoidentityprovider.model.LambdaConfigType(
        preSignUp.map(value => value),
        customMessage.map(value => value),
        postConfirmation.map(value => value),
        preAuthentication.map(value => value),
        postAuthentication.map(value => value),
        defineAuthChallenge.map(value => value),
        createAuthChallenge.map(value => value),
        verifyAuthChallengeResponse.map(value => value),
        preTokenGeneration.map(value => value),
        userMigration.map(value => value),
        customSMSSender.map(value => value.asEditable),
        customEmailSender.map(value => value.asEditable),
        kmsKeyID.map(value => value)
      )
    def preSignUp: Optional[ArnType]
    def customMessage: Optional[ArnType]
    def postConfirmation: Optional[ArnType]
    def preAuthentication: Optional[ArnType]
    def postAuthentication: Optional[ArnType]
    def defineAuthChallenge: Optional[ArnType]
    def createAuthChallenge: Optional[ArnType]
    def verifyAuthChallengeResponse: Optional[ArnType]
    def preTokenGeneration: Optional[ArnType]
    def userMigration: Optional[ArnType]
    def customSMSSender: Optional[
      zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType.ReadOnly
    ]
    def customEmailSender: Optional[
      zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType.ReadOnly
    ]
    def kmsKeyID: Optional[ArnType]
    def getPreSignUp: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("preSignUp", preSignUp)
    def getCustomMessage: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("customMessage", customMessage)
    def getPostConfirmation: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("postConfirmation", postConfirmation)
    def getPreAuthentication: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("preAuthentication", preAuthentication)
    def getPostAuthentication: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("postAuthentication", postAuthentication)
    def getDefineAuthChallenge: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("defineAuthChallenge", defineAuthChallenge)
    def getCreateAuthChallenge: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("createAuthChallenge", createAuthChallenge)
    def getVerifyAuthChallengeResponse: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField(
        "verifyAuthChallengeResponse",
        verifyAuthChallengeResponse
      )
    def getPreTokenGeneration: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("preTokenGeneration", preTokenGeneration)
    def getUserMigration: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("userMigration", userMigration)
    def getCustomSMSSender: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("customSMSSender", customSMSSender)
    def getCustomEmailSender: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("customEmailSender", customEmailSender)
    def getKmsKeyID: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("kmsKeyID", kmsKeyID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType
  ) extends zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly {
    override val preSignUp: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.preSignUp())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val customMessage: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.customMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val postConfirmation: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.postConfirmation())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val preAuthentication: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.preAuthentication())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val postAuthentication: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.postAuthentication())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val defineAuthChallenge: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.defineAuthChallenge())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val createAuthChallenge: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.createAuthChallenge())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val verifyAuthChallengeResponse: Optional[ArnType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifyAuthChallengeResponse())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
        )
    override val preTokenGeneration: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.preTokenGeneration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val userMigration: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.userMigration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val customSMSSender: Optional[
      zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customSMSSender())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType
          .wrap(value)
      )
    override val customEmailSender: Optional[
      zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customEmailSender())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType
          .wrap(value)
      )
    override val kmsKeyID: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyID())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType
  ): zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly =
    new Wrapper(impl)
}
