package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGroupResponse(
    group: Optional[zio.aws.cognitoidentityprovider.model.GroupType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse = {
    import GetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse
      .builder()
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetGroupResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetGroupResponse.wrap(buildAwsValue())
}
object GetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GetGroupResponse =
      zio.aws.cognitoidentityprovider.model
        .GetGroupResponse(group.map(value => value.asEditable))
    def group
        : Optional[zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly]
    def getGroup: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
    ] = AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse
  ) extends zio.aws.cognitoidentityprovider.model.GetGroupResponse.ReadOnly {
    override val group
        : Optional[zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.group())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.GroupType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse
  ): zio.aws.cognitoidentityprovider.model.GetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
