package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait ChallengeNameType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType
}
object ChallengeNameType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType
  ): zio.aws.cognitoidentityprovider.model.ChallengeNameType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.SMS_MFA =>
      val r = SMS_MFA
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.SOFTWARE_TOKEN_MFA =>
      val r = SOFTWARE_TOKEN_MFA
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.SELECT_MFA_TYPE =>
      val r = SELECT_MFA_TYPE
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.MFA_SETUP =>
      val r = MFA_SETUP
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.PASSWORD_VERIFIER =>
      val r = PASSWORD_VERIFIER
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.CUSTOM_CHALLENGE =>
      val r = CUSTOM_CHALLENGE
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.DEVICE_SRP_AUTH =>
      val r = DEVICE_SRP_AUTH
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.DEVICE_PASSWORD_VERIFIER =>
      val r = DEVICE_PASSWORD_VERIFIER
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.ADMIN_NO_SRP_AUTH =>
      val r = ADMIN_NO_SRP_AUTH
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.NEW_PASSWORD_REQUIRED =>
      val r = NEW_PASSWORD_REQUIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.UNKNOWN_TO_SDK_VERSION
  }
  case object SMS_MFA
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.SMS_MFA
  }
  case object SOFTWARE_TOKEN_MFA
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.SOFTWARE_TOKEN_MFA
  }
  case object SELECT_MFA_TYPE
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.SELECT_MFA_TYPE
  }
  case object MFA_SETUP
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.MFA_SETUP
  }
  case object PASSWORD_VERIFIER
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.PASSWORD_VERIFIER
  }
  case object CUSTOM_CHALLENGE
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.CUSTOM_CHALLENGE
  }
  case object DEVICE_SRP_AUTH
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.DEVICE_SRP_AUTH
  }
  case object DEVICE_PASSWORD_VERIFIER
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.DEVICE_PASSWORD_VERIFIER
  }
  case object ADMIN_NO_SRP_AUTH
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.ADMIN_NO_SRP_AUTH
  }
  case object NEW_PASSWORD_REQUIRED
      extends zio.aws.cognitoidentityprovider.model.ChallengeNameType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType.NEW_PASSWORD_REQUIRED
  }
}
