package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class UserContextDataType(
    ipAddress: Optional[StringType] = Optional.Absent,
    encodedData: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType = {
    import UserContextDataType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType
      .builder()
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(encodedData.map(value => value: java.lang.String))(
        _.encodedData
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserContextDataType
      .wrap(buildAwsValue())
}
object UserContextDataType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UserContextDataType =
      zio.aws.cognitoidentityprovider.model.UserContextDataType(
        ipAddress.map(value => value),
        encodedData.map(value => value)
      )
    def ipAddress: Optional[StringType]
    def encodedData: Optional[StringType]
    def getIpAddress: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getEncodedData: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("encodedData", encodedData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType
  ) extends zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly {
    override val ipAddress: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => value: StringType)
    override val encodedData: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.encodedData())
      .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType
  ): zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly =
    new Wrapper(impl)
}
