package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait EventResponseType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType
}
object EventResponseType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType
  ): zio.aws.cognitoidentityprovider.model.EventResponseType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.FAILURE =>
      val r = Failure
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.EventResponseType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.UNKNOWN_TO_SDK_VERSION
  }
  case object Success
      extends zio.aws.cognitoidentityprovider.model.EventResponseType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.SUCCESS
  }
  case object Failure
      extends zio.aws.cognitoidentityprovider.model.EventResponseType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.FAILURE
  }
}
