package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  ArnType,
  UserPoolIdType,
  UserImportJobNameType
}
import scala.jdk.CollectionConverters._
final case class CreateUserImportJobRequest(
    jobName: UserImportJobNameType,
    userPoolId: UserPoolIdType,
    cloudWatchLogsRoleArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest = {
    import CreateUserImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest
      .builder()
      .jobName(UserImportJobNameType.unwrap(jobName): java.lang.String)
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .cloudWatchLogsRoleArn(
        ArnType.unwrap(cloudWatchLogsRoleArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateUserImportJobRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateUserImportJobRequest
      .wrap(buildAwsValue())
}
object CreateUserImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CreateUserImportJobRequest =
      zio.aws.cognitoidentityprovider.model
        .CreateUserImportJobRequest(jobName, userPoolId, cloudWatchLogsRoleArn)
    def jobName: UserImportJobNameType
    def userPoolId: UserPoolIdType
    def cloudWatchLogsRoleArn: ArnType
    def getJobName: ZIO[Any, Nothing, UserImportJobNameType] =
      ZIO.succeed(jobName)
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getCloudWatchLogsRoleArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(cloudWatchLogsRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest
  ) extends zio.aws.cognitoidentityprovider.model.CreateUserImportJobRequest.ReadOnly {
    override val jobName: UserImportJobNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserImportJobNameType(impl.jobName())
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val cloudWatchLogsRoleArn: ArnType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ArnType(impl.cloudWatchLogsRoleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest
  ): zio.aws.cognitoidentityprovider.model.CreateUserImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
