package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  SessionType,
  SecretCodeType
}
import scala.jdk.CollectionConverters._
final case class AssociateSoftwareTokenResponse(
    secretCode: Optional[SecretCodeType] = Optional.Absent,
    session: Optional[SessionType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse = {
    import AssociateSoftwareTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
      .builder()
      .optionallyWith(
        secretCode.map(value => SecretCodeType.unwrap(value): java.lang.String)
      )(_.secretCode)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
      .wrap(buildAwsValue())
}
object AssociateSoftwareTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse =
      zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse(
        secretCode.map(value => value),
        session.map(value => value)
      )
    def secretCode: Optional[SecretCodeType]
    def session: Optional[SessionType]
    def getSecretCode: ZIO[Any, AwsError, SecretCodeType] =
      AwsError.unwrapOptionField("secretCode", secretCode)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
  ) extends zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly {
    override val secretCode: Optional[SecretCodeType] = zio.aws.core.internal
      .optionalFromNullable(impl.secretCode())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SecretCodeType(value)
      )
    override val session: Optional[SessionType] = zio.aws.core.internal
      .optionalFromNullable(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
  ): zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly =
    new Wrapper(impl)
}
