package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  ClientSecretType,
  ClientIdType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class RevokeTokenRequest(
    token: TokenModelType,
    clientId: ClientIdType,
    clientSecret: Optional[ClientSecretType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest = {
    import RevokeTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest
      .builder()
      .token(TokenModelType.unwrap(token): java.lang.String)
      .clientId(ClientIdType.unwrap(clientId): java.lang.String)
      .optionallyWith(
        clientSecret.map(value =>
          ClientSecretType.unwrap(value): java.lang.String
        )
      )(_.clientSecret)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.RevokeTokenRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.RevokeTokenRequest
      .wrap(buildAwsValue())
}
object RevokeTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.RevokeTokenRequest =
      zio.aws.cognitoidentityprovider.model
        .RevokeTokenRequest(token, clientId, clientSecret.map(value => value))
    def token: TokenModelType
    def clientId: ClientIdType
    def clientSecret: Optional[ClientSecretType]
    def getToken: ZIO[Any, Nothing, TokenModelType] = ZIO.succeed(token)
    def getClientId: ZIO[Any, Nothing, ClientIdType] = ZIO.succeed(clientId)
    def getClientSecret: ZIO[Any, AwsError, ClientSecretType] =
      AwsError.unwrapOptionField("clientSecret", clientSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest
  ) extends zio.aws.cognitoidentityprovider.model.RevokeTokenRequest.ReadOnly {
    override val token: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.token())
    override val clientId: ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ClientIdType(impl.clientId())
    override val clientSecret: Optional[ClientSecretType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientSecret())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .ClientSecretType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest
  ): zio.aws.cognitoidentityprovider.model.RevokeTokenRequest.ReadOnly =
    new Wrapper(impl)
}
