package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  UserPoolIdType,
  GroupNameType
}
import scala.jdk.CollectionConverters._
final case class GetGroupRequest(
    groupName: GroupNameType,
    userPoolId: UserPoolIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest = {
    import GetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetGroupRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetGroupRequest.wrap(buildAwsValue())
}
object GetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GetGroupRequest =
      zio.aws.cognitoidentityprovider.model
        .GetGroupRequest(groupName, userPoolId)
    def groupName: GroupNameType
    def userPoolId: UserPoolIdType
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest
  ) extends zio.aws.cognitoidentityprovider.model.GetGroupRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .GroupNameType(impl.groupName())
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest
  ): zio.aws.cognitoidentityprovider.model.GetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
