package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait PreventUserExistenceErrorTypes {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes
}
object PreventUserExistenceErrorTypes {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes
  ): zio.aws.cognitoidentityprovider.model.PreventUserExistenceErrorTypes =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes.LEGACY =>
        val r = LEGACY
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes.ENABLED =>
        val r = ENABLED
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.PreventUserExistenceErrorTypes {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes =
      software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object LEGACY
      extends zio.aws.cognitoidentityprovider.model.PreventUserExistenceErrorTypes {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes =
      software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes.LEGACY
  }
  case object ENABLED
      extends zio.aws.cognitoidentityprovider.model.PreventUserExistenceErrorTypes {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes =
      software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes.ENABLED
  }
}
