package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKeyType
import scala.jdk.CollectionConverters._
final case class ListResourceServersResponse(
    resourceServers: Iterable[
      zio.aws.cognitoidentityprovider.model.ResourceServerType
    ],
    nextToken: Optional[PaginationKeyType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse = {
    import ListResourceServersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse
      .builder()
      .resourceServers(resourceServers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value =>
          PaginationKeyType.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListResourceServersResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListResourceServersResponse
      .wrap(buildAwsValue())
}
object ListResourceServersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListResourceServersResponse =
      zio.aws.cognitoidentityprovider.model.ListResourceServersResponse(
        resourceServers.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def resourceServers: List[
      zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly
    ]
    def nextToken: Optional[PaginationKeyType]
    def getResourceServers: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly
    ]] = ZIO.succeed(resourceServers)
    def getNextToken: ZIO[Any, AwsError, PaginationKeyType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListResourceServersResponse.ReadOnly {
    override val resourceServers: List[
      zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly
    ] = impl
      .resourceServers()
      .asScala
      .map { item =>
        zio.aws.cognitoidentityprovider.model.ResourceServerType.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .PaginationKeyType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse
  ): zio.aws.cognitoidentityprovider.model.ListResourceServersResponse.ReadOnly =
    new Wrapper(impl)
}
