package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait EventFilterType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType
}
object EventFilterType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType
  ): zio.aws.cognitoidentityprovider.model.EventFilterType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType.SIGN_IN =>
      val r = SIGN_IN
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType.PASSWORD_CHANGE =>
      val r = PASSWORD_CHANGE
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType.SIGN_UP =>
      val r = SIGN_UP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.EventFilterType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object SIGN_IN
      extends zio.aws.cognitoidentityprovider.model.EventFilterType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType.SIGN_IN
  }
  case object PASSWORD_CHANGE
      extends zio.aws.cognitoidentityprovider.model.EventFilterType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType.PASSWORD_CHANGE
  }
  case object SIGN_UP
      extends zio.aws.cognitoidentityprovider.model.EventFilterType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType.SIGN_UP
  }
}
