package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  ResourceServerNameType,
  ResourceServerIdentifierType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class CreateResourceServerRequest(
    userPoolId: UserPoolIdType,
    identifier: ResourceServerIdentifierType,
    name: ResourceServerNameType,
    scopes: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.ResourceServerScopeType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest = {
    import CreateResourceServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .identifier(
        ResourceServerIdentifierType.unwrap(identifier): java.lang.String
      )
      .name(ResourceServerNameType.unwrap(name): java.lang.String)
      .optionallyWith(
        scopes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scopes)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateResourceServerRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateResourceServerRequest
      .wrap(buildAwsValue())
}
object CreateResourceServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CreateResourceServerRequest =
      zio.aws.cognitoidentityprovider.model.CreateResourceServerRequest(
        userPoolId,
        identifier,
        name,
        scopes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def userPoolId: UserPoolIdType
    def identifier: ResourceServerIdentifierType
    def name: ResourceServerNameType
    def scopes: Optional[List[
      zio.aws.cognitoidentityprovider.model.ResourceServerScopeType.ReadOnly
    ]]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getIdentifier: ZIO[Any, Nothing, ResourceServerIdentifierType] =
      ZIO.succeed(identifier)
    def getName: ZIO[Any, Nothing, ResourceServerNameType] = ZIO.succeed(name)
    def getScopes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.ResourceServerScopeType.ReadOnly
    ]] = AwsError.unwrapOptionField("scopes", scopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest
  ) extends zio.aws.cognitoidentityprovider.model.CreateResourceServerRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val identifier: ResourceServerIdentifierType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ResourceServerIdentifierType(impl.identifier())
    override val name: ResourceServerNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ResourceServerNameType(impl.name())
    override val scopes: Optional[List[
      zio.aws.cognitoidentityprovider.model.ResourceServerScopeType.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.scopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.ResourceServerScopeType
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest
  ): zio.aws.cognitoidentityprovider.model.CreateResourceServerRequest.ReadOnly =
    new Wrapper(impl)
}
