package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKeyType
import scala.jdk.CollectionConverters._
final case class ListUserPoolsResponse(
    userPools: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType]
    ] = Optional.Absent,
    nextToken: Optional[PaginationKeyType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse = {
    import ListUserPoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse
      .builder()
      .optionallyWith(
        userPools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userPools)
      .optionallyWith(
        nextToken.map(value =>
          PaginationKeyType.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse
      .wrap(buildAwsValue())
}
object ListUserPoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse =
      zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse(
        userPools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def userPools: Optional[List[
      zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
    ]]
    def nextToken: Optional[PaginationKeyType]
    def getUserPools: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
    ]] = AwsError.unwrapOptionField("userPools", userPools)
    def getNextToken: ZIO[Any, AwsError, PaginationKeyType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly {
    override val userPools: Optional[List[
      zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.userPools())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .PaginationKeyType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse
  ): zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly =
    new Wrapper(impl)
}
