package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountTakeoverActionsType(
    lowAction: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType
    ] = Optional.Absent,
    mediumAction: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType
    ] = Optional.Absent,
    highAction: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverActionsType = {
    import AccountTakeoverActionsType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverActionsType
      .builder()
      .optionallyWith(lowAction.map(value => value.buildAwsValue()))(
        _.lowAction
      )
      .optionallyWith(mediumAction.map(value => value.buildAwsValue()))(
        _.mediumAction
      )
      .optionallyWith(highAction.map(value => value.buildAwsValue()))(
        _.highAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType
      .wrap(buildAwsValue())
}
object AccountTakeoverActionsType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverActionsType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType =
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType(
        lowAction.map(value => value.asEditable),
        mediumAction.map(value => value.asEditable),
        highAction.map(value => value.asEditable)
      )
    def lowAction: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly
    ]
    def mediumAction: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly
    ]
    def highAction: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly
    ]
    def getLowAction: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly
    ] = AwsError.unwrapOptionField("lowAction", lowAction)
    def getMediumAction: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly
    ] = AwsError.unwrapOptionField("mediumAction", mediumAction)
    def getHighAction: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly
    ] = AwsError.unwrapOptionField("highAction", highAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverActionsType
  ) extends zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType.ReadOnly {
    override val lowAction: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lowAction())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType
          .wrap(value)
      )
    override val mediumAction: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediumAction())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType
          .wrap(value)
      )
    override val highAction: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.highAction())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverActionsType
  ): zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType.ReadOnly =
    new Wrapper(impl)
}
