package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  DeviceNameType,
  DeviceKeyType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class ConfirmDeviceRequest(
    accessToken: TokenModelType,
    deviceKey: DeviceKeyType,
    deviceSecretVerifierConfig: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType
    ] = Optional.Absent,
    deviceName: Optional[DeviceNameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest = {
    import ConfirmDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest
      .builder()
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .deviceKey(DeviceKeyType.unwrap(deviceKey): java.lang.String)
      .optionallyWith(
        deviceSecretVerifierConfig.map(value => value.buildAwsValue())
      )(_.deviceSecretVerifierConfig)
      .optionallyWith(
        deviceName.map(value => DeviceNameType.unwrap(value): java.lang.String)
      )(_.deviceName)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ConfirmDeviceRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ConfirmDeviceRequest
      .wrap(buildAwsValue())
}
object ConfirmDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ConfirmDeviceRequest =
      zio.aws.cognitoidentityprovider.model.ConfirmDeviceRequest(
        accessToken,
        deviceKey,
        deviceSecretVerifierConfig.map(value => value.asEditable),
        deviceName.map(value => value)
      )
    def accessToken: TokenModelType
    def deviceKey: DeviceKeyType
    def deviceSecretVerifierConfig: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType.ReadOnly
    ]
    def deviceName: Optional[DeviceNameType]
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
    def getDeviceKey: ZIO[Any, Nothing, DeviceKeyType] = ZIO.succeed(deviceKey)
    def getDeviceSecretVerifierConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deviceSecretVerifierConfig",
      deviceSecretVerifierConfig
    )
    def getDeviceName: ZIO[Any, AwsError, DeviceNameType] =
      AwsError.unwrapOptionField("deviceName", deviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest
  ) extends zio.aws.cognitoidentityprovider.model.ConfirmDeviceRequest.ReadOnly {
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
    override val deviceKey: DeviceKeyType =
      zio.aws.cognitoidentityprovider.model.primitives
        .DeviceKeyType(impl.deviceKey())
    override val deviceSecretVerifierConfig: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceSecretVerifierConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType
          .wrap(value)
      )
    override val deviceName: Optional[DeviceNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DeviceNameType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest
  ): zio.aws.cognitoidentityprovider.model.ConfirmDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
