package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.BooleanType
import scala.jdk.CollectionConverters._
final case class SMSMfaSettingsType(
    enabled: Optional[BooleanType] = Optional.Absent,
    preferredMfa: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SMSMfaSettingsType = {
    import SMSMfaSettingsType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SMSMfaSettingsType
      .builder()
      .optionallyWith(
        enabled.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        preferredMfa.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.preferredMfa)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType
      .wrap(buildAwsValue())
}
object SMSMfaSettingsType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SMSMfaSettingsType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType =
      zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType(
        enabled.map(value => value),
        preferredMfa.map(value => value)
      )
    def enabled: Optional[BooleanType]
    def preferredMfa: Optional[BooleanType]
    def getEnabled: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getPreferredMfa: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("preferredMfa", preferredMfa)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SMSMfaSettingsType
  ) extends zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.ReadOnly {
    override val enabled: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val preferredMfa: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredMfa())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SMSMfaSettingsType
  ): zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.ReadOnly =
    new Wrapper(impl)
}
