package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  DateType,
  ClientIdType,
  UserPoolIdType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RiskConfigurationType(
    userPoolId: Optional[UserPoolIdType] = Optional.Absent,
    clientId: Optional[ClientIdType] = Optional.Absent,
    compromisedCredentialsRiskConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
    ] = Optional.Absent,
    accountTakeoverRiskConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
    ] = Optional.Absent,
    riskExceptionConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType
    ] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskConfigurationType = {
    import RiskConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.RiskConfigurationType
      .builder()
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        clientId.map(value => ClientIdType.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        compromisedCredentialsRiskConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.compromisedCredentialsRiskConfiguration)
      .optionallyWith(
        accountTakeoverRiskConfiguration.map(value => value.buildAwsValue())
      )(_.accountTakeoverRiskConfiguration)
      .optionallyWith(
        riskExceptionConfiguration.map(value => value.buildAwsValue())
      )(_.riskExceptionConfiguration)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.RiskConfigurationType
      .wrap(buildAwsValue())
}
object RiskConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.RiskConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.RiskConfigurationType =
      zio.aws.cognitoidentityprovider.model.RiskConfigurationType(
        userPoolId.map(value => value),
        clientId.map(value => value),
        compromisedCredentialsRiskConfiguration.map(value => value.asEditable),
        accountTakeoverRiskConfiguration.map(value => value.asEditable),
        riskExceptionConfiguration.map(value => value.asEditable),
        lastModifiedDate.map(value => value)
      )
    def userPoolId: Optional[UserPoolIdType]
    def clientId: Optional[ClientIdType]
    def compromisedCredentialsRiskConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly
    ]
    def accountTakeoverRiskConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly
    ]
    def riskExceptionConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly
    ]
    def lastModifiedDate: Optional[DateType]
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getClientId: ZIO[Any, AwsError, ClientIdType] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getCompromisedCredentialsRiskConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "compromisedCredentialsRiskConfiguration",
      compromisedCredentialsRiskConfiguration
    )
    def getAccountTakeoverRiskConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountTakeoverRiskConfiguration",
      accountTakeoverRiskConfiguration
    )
    def getRiskExceptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "riskExceptionConfiguration",
      riskExceptionConfiguration
    )
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RiskConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly {
    override val userPoolId: Optional[UserPoolIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val clientId: Optional[ClientIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientIdType(value)
      )
    override val compromisedCredentialsRiskConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.compromisedCredentialsRiskConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
          .wrap(value)
      )
    override val accountTakeoverRiskConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountTakeoverRiskConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
          .wrap(value)
      )
    override val riskExceptionConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.riskExceptionConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType
          .wrap(value)
      )
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RiskConfigurationType
  ): zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly =
    new Wrapper(impl)
}
