package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  DeviceKeyType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class ForgetDeviceRequest(
    accessToken: Optional[TokenModelType] = Optional.Absent,
    deviceKey: DeviceKeyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest = {
    import ForgetDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest
      .builder()
      .optionallyWith(
        accessToken.map(value => TokenModelType.unwrap(value): java.lang.String)
      )(_.accessToken)
      .deviceKey(DeviceKeyType.unwrap(deviceKey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ForgetDeviceRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ForgetDeviceRequest
      .wrap(buildAwsValue())
}
object ForgetDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ForgetDeviceRequest =
      zio.aws.cognitoidentityprovider.model
        .ForgetDeviceRequest(accessToken.map(value => value), deviceKey)
    def accessToken: Optional[TokenModelType]
    def deviceKey: DeviceKeyType
    def getAccessToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getDeviceKey: ZIO[Any, Nothing, DeviceKeyType] = ZIO.succeed(deviceKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest
  ) extends zio.aws.cognitoidentityprovider.model.ForgetDeviceRequest.ReadOnly {
    override val accessToken: Optional[TokenModelType] = zio.aws.core.internal
      .optionalFromNullable(impl.accessToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
    override val deviceKey: DeviceKeyType =
      zio.aws.cognitoidentityprovider.model.primitives
        .DeviceKeyType(impl.deviceKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest
  ): zio.aws.cognitoidentityprovider.model.ForgetDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
