package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  ProviderNameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class DeleteIdentityProviderRequest(
    userPoolId: UserPoolIdType,
    providerName: ProviderNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest = {
    import DeleteIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .providerName(ProviderNameType.unwrap(providerName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DeleteIdentityProviderRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DeleteIdentityProviderRequest
      .wrap(buildAwsValue())
}
object DeleteIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DeleteIdentityProviderRequest =
      zio.aws.cognitoidentityprovider.model
        .DeleteIdentityProviderRequest(userPoolId, providerName)
    def userPoolId: UserPoolIdType
    def providerName: ProviderNameType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getProviderName: ZIO[Any, Nothing, ProviderNameType] =
      ZIO.succeed(providerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest
  ) extends zio.aws.cognitoidentityprovider.model.DeleteIdentityProviderRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val providerName: ProviderNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ProviderNameType(impl.providerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest
  ): zio.aws.cognitoidentityprovider.model.DeleteIdentityProviderRequest.ReadOnly =
    new Wrapper(impl)
}
