package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  SessionType,
  ClientIdType
}
import scala.jdk.CollectionConverters._
final case class RespondToAuthChallengeRequest(
    clientId: ClientIdType,
    challengeName: zio.aws.cognitoidentityprovider.model.ChallengeNameType,
    session: Optional[SessionType] = Optional.Absent,
    challengeResponses: Optional[Map[StringType, StringType]] = Optional.Absent,
    analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType
    ] = Optional.Absent,
    userContextData: Optional[
      zio.aws.cognitoidentityprovider.model.UserContextDataType
    ] = Optional.Absent,
    clientMetadata: Optional[Map[StringType, StringType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest = {
    import RespondToAuthChallengeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest
      .builder()
      .clientId(ClientIdType.unwrap(clientId): java.lang.String)
      .challengeName(challengeName.unwrap)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .optionallyWith(
        challengeResponses.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.challengeResponses)
      .optionallyWith(analyticsMetadata.map(value => value.buildAwsValue()))(
        _.analyticsMetadata
      )
      .optionallyWith(userContextData.map(value => value.buildAwsValue()))(
        _.userContextData
      )
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeRequest
      .wrap(buildAwsValue())
}
object RespondToAuthChallengeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeRequest =
      zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeRequest(
        clientId,
        challengeName,
        session.map(value => value),
        challengeResponses.map(value => value),
        analyticsMetadata.map(value => value.asEditable),
        userContextData.map(value => value.asEditable),
        clientMetadata.map(value => value)
      )
    def clientId: ClientIdType
    def challengeName: zio.aws.cognitoidentityprovider.model.ChallengeNameType
    def session: Optional[SessionType]
    def challengeResponses: Optional[Map[StringType, StringType]]
    def analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ]
    def userContextData: Optional[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ]
    def clientMetadata: Optional[Map[StringType, StringType]]
    def getClientId: ZIO[Any, Nothing, ClientIdType] = ZIO.succeed(clientId)
    def getChallengeName: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.ChallengeNameType
    ] = ZIO.succeed(challengeName)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
    def getChallengeResponses: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("challengeResponses", challengeResponses)
    def getAnalyticsMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = AwsError.unwrapOptionField("analyticsMetadata", analyticsMetadata)
    def getUserContextData: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = AwsError.unwrapOptionField("userContextData", userContextData)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest
  ) extends zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeRequest.ReadOnly {
    override val clientId: ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ClientIdType(impl.clientId())
    override val challengeName
        : zio.aws.cognitoidentityprovider.model.ChallengeNameType =
      zio.aws.cognitoidentityprovider.model.ChallengeNameType
        .wrap(impl.challengeName())
    override val session: Optional[SessionType] = zio.aws.core.internal
      .optionalFromNullable(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
    override val challengeResponses: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.challengeResponses())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
    override val analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.analyticsMetadata())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.wrap(value)
      )
    override val userContextData: Optional[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userContextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserContextDataType.wrap(value)
      )
    override val clientMetadata: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest
  ): zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeRequest.ReadOnly =
    new Wrapper(impl)
}
