package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait CustomEmailSenderLambdaVersionType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType
}
object CustomEmailSenderLambdaVersionType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType
  ): zio.aws.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType.V1_0 =>
        val r = V1_0
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType.UNKNOWN_TO_SDK_VERSION
  }
  case object V1_0
      extends zio.aws.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType.V1_0
  }
}
