package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  IntegerType,
  TokenModelType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AuthenticationResultType(
    accessToken: Optional[TokenModelType] = Optional.Absent,
    expiresIn: Optional[IntegerType] = Optional.Absent,
    tokenType: Optional[StringType] = Optional.Absent,
    refreshToken: Optional[TokenModelType] = Optional.Absent,
    idToken: Optional[TokenModelType] = Optional.Absent,
    newDeviceMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType = {
    import AuthenticationResultType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType
      .builder()
      .optionallyWith(
        accessToken.map(value => TokenModelType.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        expiresIn.map(value => IntegerType.unwrap(value): Integer)
      )(_.expiresIn)
      .optionallyWith(tokenType.map(value => value: java.lang.String))(
        _.tokenType
      )
      .optionallyWith(
        refreshToken.map(value =>
          TokenModelType.unwrap(value): java.lang.String
        )
      )(_.refreshToken)
      .optionallyWith(
        idToken.map(value => TokenModelType.unwrap(value): java.lang.String)
      )(_.idToken)
      .optionallyWith(newDeviceMetadata.map(value => value.buildAwsValue()))(
        _.newDeviceMetadata
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AuthenticationResultType
      .wrap(buildAwsValue())
}
object AuthenticationResultType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AuthenticationResultType =
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType(
        accessToken.map(value => value),
        expiresIn.map(value => value),
        tokenType.map(value => value),
        refreshToken.map(value => value),
        idToken.map(value => value),
        newDeviceMetadata.map(value => value.asEditable)
      )
    def accessToken: Optional[TokenModelType]
    def expiresIn: Optional[IntegerType]
    def tokenType: Optional[StringType]
    def refreshToken: Optional[TokenModelType]
    def idToken: Optional[TokenModelType]
    def newDeviceMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.ReadOnly
    ]
    def getAccessToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getExpiresIn: ZIO[Any, AwsError, IntegerType] =
      AwsError.unwrapOptionField("expiresIn", expiresIn)
    def getTokenType: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("tokenType", tokenType)
    def getRefreshToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("refreshToken", refreshToken)
    def getIdToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("idToken", idToken)
    def getNewDeviceMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.ReadOnly
    ] = AwsError.unwrapOptionField("newDeviceMetadata", newDeviceMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType
  ) extends zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly {
    override val accessToken: Optional[TokenModelType] = zio.aws.core.internal
      .optionalFromNullable(impl.accessToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
    override val expiresIn: Optional[IntegerType] = zio.aws.core.internal
      .optionalFromNullable(impl.expiresIn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.IntegerType(value)
      )
    override val tokenType: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenType())
      .map(value => value: StringType)
    override val refreshToken: Optional[TokenModelType] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
    override val idToken: Optional[TokenModelType] = zio.aws.core.internal
      .optionalFromNullable(impl.idToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
    override val newDeviceMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.newDeviceMetadata())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType
  ): zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly =
    new Wrapper(impl)
}
